#!/usr/bin/env python
"""
Odbicia
Test w Raspberry Pi
"""
import time                     # Na potrzeby dodawania opnie
import os, pygame, sys

pygame.init()                   # Inicjowanie interfejsu graficznego
os.environ['SDL_VIDEO_WINDOW_POS'] = 'center'
pygame.display.set_caption("Odbicia")
screenWidth = 400
screenHeight =400
screen = pygame.display.set_mode([screenWidth,screenHeight],0,32)
background = pygame.Surface((screenWidth,screenHeight))

# Definiowanie kolorw interfejsu uytkownika
cBackground =(255,255,255)
cBlock = (0,0,0)
background.fill(cBackground) # Okrelanie koloru ta
dx = 5
dy = 10

def main():
   X = screenWidth / 2
   Y = screenHeight /2
   screen.blit(background,[0,0])
   while True :
            checkForEvent()
            #time.sleep(0.05)
            drawScreen(X,Y)
            X += dx
            Y += dy
            checkBounds(X,Y)
def checkBounds(px,py):
    global dx,dy
    if px > screenWidth-10 or px <0:
       dx = -dx
    if py > screenHeight-10 or py < 0:
       dy = - dy
       
def drawScreen(px,py) : # Rysowanie na ekranie
    screen.blit(background,[0,0]) # Okrelanie koloru ta
    pygame.draw.rect(screen,cBlock, (px, py, 10 ,10), 0)
    pygame.display.update()
         
def terminate(): # Zamykanie programu
    print ("Trwa zamykanie programu - prosz czeka")
    pygame.quit() # Usuwanie obiektu pygame
    sys.exit()
    
def checkForEvent(): # Sprawdzanie, czy naley zamkn program
    event = pygame.event.poll()
    if event.type == pygame.QUIT :
           terminate()
    if event.type == pygame.KEYDOWN and event.key == pygame.K_ESCAPE :
            terminate()
            
            
if __name__ == '__main__':
    main()   
